/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.provider.jffi.AbstractX86StubCompiler;
import com.kenai.jaffl.provider.jffi.CodegenUtils;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jnr.x86asm.Asm;
import com.kenai.jnr.x86asm.Assembler;
import com.kenai.jnr.x86asm.Register;

final class X86_32StubCompiler
extends AbstractX86StubCompiler {
    X86_32StubCompiler() {
    }

    boolean canCompile(Class clazz, Class[] classArray, CallingConvention callingConvention) {
        if (clazz != Byte.TYPE && clazz != Short.TYPE && clazz != Integer.TYPE && clazz != Long.TYPE && clazz != Float.TYPE && clazz != Double.TYPE && clazz != Void.TYPE) {
            return false;
        }
        if (callingConvention != CallingConvention.DEFAULT) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        for (Class clazz2 : classArray) {
            if (clazz2 == Byte.TYPE || clazz2 == Short.TYPE || clazz2 == Integer.TYPE || clazz2 == Long.TYPE) {
                ++n2;
                continue;
            }
            if (clazz2 == Float.TYPE || clazz2 == Double.TYPE) {
                ++n;
                continue;
            }
            return false;
        }
        return true;
    }

    void compile(Function function, String string, Class clazz, Class[] classArray, CallingConvention callingConvention, boolean bl) {
        int n;
        int n2 = 0;
        for (Class clazz2 : classArray) {
            if (clazz2 == Byte.TYPE || clazz2 == Short.TYPE || clazz2 == Integer.TYPE || clazz2 == Float.TYPE) {
                n2 += 4;
                continue;
            }
            if (clazz2 == Long.TYPE || clazz2 == Double.TYPE) {
                n2 += 8;
                continue;
            }
            throw new IllegalArgumentException("invalid parameter type" + clazz2);
        }
        int n3 = 0;
        if (Double.TYPE == clazz || Float.TYPE == clazz) {
            n3 = 16;
        } else if (Long.TYPE == clazz) {
            n3 = 8;
        } else if (Byte.TYPE == clazz || Short.TYPE == clazz || Integer.TYPE == clazz) {
            n3 = 4;
        } else if (Void.TYPE == clazz) {
            n3 = 0;
        } else {
            throw new IllegalArgumentException("invalid return type " + clazz);
        }
        int n4 = X86_32StubCompiler.align(Math.max(n2, n3) + 4, 16) - 4;
        Assembler assembler = new Assembler(Asm.X86_32);
        assembler.sub(Asm.esp, Asm.imm((long)n4));
        for (n = 0; n < n2; n += 4) {
            assembler.mov(Asm.eax, Asm.dword_ptr((Register)Asm.esp, (long)(n4 + 4 + 8 + n)));
            assembler.mov(Asm.dword_ptr((Register)Asm.esp, (long)n), Asm.eax);
        }
        assembler.mov(Asm.eax, Asm.imm((long)function.getFunctionAddress()));
        assembler.call(Asm.eax);
        if (bl) {
            n = 0;
            if (Float.TYPE == clazz) {
                assembler.fstp(Asm.dword_ptr((Register)Asm.esp, (long)n));
            } else if (Double.TYPE == clazz) {
                assembler.fstp(Asm.qword_ptr((Register)Asm.esp, (long)n));
            } else if (Long.TYPE == clazz) {
                assembler.mov(Asm.dword_ptr((Register)Asm.esp, (long)n), Asm.eax);
                assembler.mov(Asm.dword_ptr((Register)Asm.esp, (long)(n + 4)), Asm.edx);
            } else if (Void.TYPE != clazz) {
                assembler.mov(Asm.dword_ptr((Register)Asm.esp, (long)n), Asm.eax);
            }
            assembler.mov(Asm.eax, Asm.imm((long)errnoFunctionAddress));
            assembler.call(Asm.eax);
            if (Float.TYPE == clazz) {
                assembler.fld(Asm.dword_ptr((Register)Asm.esp, (long)n));
            } else if (Double.TYPE == clazz) {
                assembler.fld(Asm.qword_ptr((Register)Asm.esp, (long)n));
            } else if (Long.TYPE == clazz) {
                assembler.mov(Asm.eax, Asm.dword_ptr((Register)Asm.esp, (long)n));
                assembler.mov(Asm.edx, Asm.dword_ptr((Register)Asm.esp, (long)(n + 4)));
            } else if (Void.TYPE != clazz) {
                assembler.mov(Asm.eax, Asm.dword_ptr((Register)Asm.esp, (long)n));
            }
        }
        assembler.add(Asm.esp, Asm.imm((long)n4));
        assembler.ret();
        this.stubs.add(new AbstractX86StubCompiler.Stub(string, CodegenUtils.sig(clazz, classArray), assembler));
    }
}

